package com.example;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.net.URLEncoder;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.EntityUtils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class Database {

    public static JsonObject query(ConnectionInfo connInfo, String query) {
        JsonObject jsonObject = null;
        try {
            String encodedQuery = URLEncoder.encode(query, StandardCharsets.UTF_8.toString());
            String url = connInfo.getInstanceUrl() + 
                "/services/data/v58.0/query?q=" + encodedQuery;
                System.out.println(url);
            HttpGet req = new HttpGet(url);
            req.setHeader("Content-type", "application/x-www-form-urlencoded");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonObject batchQuery(ConnectionInfo connInfo, String queryUrl, Integer batchSize) {
        JsonObject jsonObject = null;
        try {
            String url = connInfo.getInstanceUrl() + queryUrl;

            HttpGet req = new HttpGet(url);
            req.setHeader("Content-type", "application/x-www-form-urlencoded");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());
            req.setHeader("Sforce-Query-Options", "batchSize=" + batchSize.toString());

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonObject querySingle(ConnectionInfo connInfo, String objectName, String recordId) {
        JsonObject jsonObject = null;
        try {
            String serviceEndpoint = "/services/data/v58.0/sobjects/" + objectName + "/" + recordId;
            String url = connInfo.getInstanceUrl() + serviceEndpoint;

            HttpGet req = new HttpGet(url);
            req.setHeader("Content-type", "application/x-www-form-urlencoded");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonObject createRecord(ConnectionInfo connInfo, String objectName, String jsonBody) {
        JsonObject jsonObject = null;
        try {
            String serviceEndpoint = "/services/data/v58.0/sobjects/" + objectName + "/";
            String url = connInfo.getInstanceUrl() + serviceEndpoint;

            HttpPost req = new HttpPost(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            req.setEntity(new StringEntity(jsonBody, ContentType.APPLICATION_JSON));

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonObject updateRecord(ConnectionInfo connInfo, String objectName, String recordId, String jsonBody) {
        JsonObject jsonObject = null;
        try {
            String serviceEndpoint = "/services/data/v58.0/sobjects/" + objectName + "/" + recordId;
            String url = connInfo.getInstanceUrl() + serviceEndpoint;

            HttpPatch req = new HttpPatch(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            req.setEntity(new StringEntity(jsonBody, ContentType.APPLICATION_JSON));

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonObject deleteRecord(ConnectionInfo connInfo, String objectName, String recordId) {
        JsonObject jsonObject = null;
        try {
            String serviceEndpoint = "/services/data/v58.0/sobjects/" + objectName + "/" + recordId;
            String url = connInfo.getInstanceUrl() + serviceEndpoint;

            HttpDelete req = new HttpDelete(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

    public static JsonArray createRecords(ConnectionInfo connInfo, String jsonString) {
        JsonArray jsonArray = null;
        try {
            String url = connInfo.getInstanceUrl() + 
                "/services/data/v58.0/composite/sobjects";

            HttpPost req = new HttpPost(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            req.setEntity(new StringEntity(jsonString, ContentType.APPLICATION_JSON));

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonArray = jl.getAsJsonArray();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }


        return jsonArray;
    }

    public static JsonArray updateRecords(ConnectionInfo connInfo, String jsonString) {
        JsonArray jsonArray = null;
        try {
            String url = connInfo.getInstanceUrl() + 
                "/services/data/v58.0/composite/sobjects";

            HttpPatch req = new HttpPatch(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            req.setEntity(new StringEntity(jsonString, ContentType.APPLICATION_JSON));
            
            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonArray = jl.getAsJsonArray();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonArray;
    }

    public static JsonArray deleteRecords(ConnectionInfo connInfo, String ids) {
        JsonArray jsonArray = null;
        try {
            String url = connInfo.getInstanceUrl() + 
                "/services/data/v58.0/composite/sobjects?ids=" + ids;

            HttpDelete req = new HttpDelete(url);
            req.setHeader("Content-type", "application/json");
            req.setHeader("Authorization", "Bearer " + connInfo.getAccessToken());

            String result = call(req);

            try {
                JsonElement jl = JsonParser.parseString(result);
                jsonArray = jl.getAsJsonArray();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();
        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonArray;
    }

    public static String call(HttpRequestBase req) {
        String result = null;
        try {
            HttpClient client = HttpClientBuilder.create().build();
            HttpResponse response = null;
            try {
                response = client.execute(req);
                System.out.println(response.getStatusLine());
            } catch(UnsupportedEncodingException ueException){
                ueException.printStackTrace();
            } catch(ClientProtocolException cpException){
                cpException.printStackTrace();
            } catch(IOException ioException){
                ioException.printStackTrace();
            }

            final int statusCode = response.getStatusLine().getStatusCode();
            try {
                if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                    result = EntityUtils.toString(response.getEntity());
                } else if(statusCode == HttpStatus.SC_NO_CONTENT) {
                    result = "{\"result\":\"success\"}";
                } else {
                    System.out.println("Error authenticating to Force.com: "+statusCode);
                    System.out.println(response.toString());
                    return null;    
                }
    
            } catch (IOException ioException) {
                ioException.printStackTrace();
            }

        } catch (Exception e) {
            System.out.println(e);
        }

        return result;
    }

}
