package com.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class Auth {

    public static PrivateKey getPrivateKeyFromJKS(String filePath, String alias, String password) throws Exception {
        PrivateKey privateKey = null;
        try {
            //Load the private key from a jks keystore
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(new FileInputStream(filePath), password.toCharArray());
 
            privateKey = (PrivateKey) keystore.getKey(alias, password.toCharArray());
        } catch (Exception e) {
            System.out.println(e);
        }

        return privateKey;
    }


    public static PrivateKey getPrivateKeyFromString(String pkcs8PrivateKeyString) throws Exception {
        PrivateKey privateKey = null;
        try {            
            KeyFactory factory;
            factory = KeyFactory.getInstance("RSA");
            byte[] encodedPK = Base64.decodeBase64(pkcs8PrivateKeyString);
            PKCS8EncodedKeySpec keySpecPv = new PKCS8EncodedKeySpec(encodedPK);
            privateKey = factory.generatePrivate(keySpecPv);
        } catch (Exception e) {
            System.out.println(e);
        }

        return privateKey;
    }

    public static PrivateKey getPrivateKeyFromKeyFile(String filePath) throws Exception {
        PrivateKey privateKey = null;
        File file = new File(filePath);
        
        try (FileReader keyReader = new FileReader(file);
            PemReader pemReader = new PemReader(keyReader)){
                PemObject pemObject = pemReader.readPemObject();
                byte[] content = pemObject.getContent();
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(content);
                KeyFactory factory = KeyFactory.getInstance("RSA");

                privateKey = (PrivateKey) factory.generatePrivate(privKeySpec);

        } catch (Exception e) {
            System.out.println(e);
        }

        return privateKey;
    }

    // public static PrivateKey getPrivateKeyFromKeyFile(String filePath) throws Exception {
    //     PrivateKey privateKey = null;
    //     try {
    //         //Load the private key from a PEM private key file
    //         File file = new File(filePath);
    //         String key = new String(Files.readAllBytes(file.toPath()), Charset.defaultCharset());

    //         String pkcs8PrivateKeyString = key
    //             .replace("-----BEGIN PRIVATE KEY-----", "")
    //             .replaceAll(System.lineSeparator(), "")
    //             .replace("-----END PRIVATE KEY-----", "");

    //         KeyFactory factory;
    //         factory = KeyFactory.getInstance("RSA");

    //         byte[] encodedPK = Base64.decodeBase64(pkcs8PrivateKeyString);
    //         PKCS8EncodedKeySpec keySpecPv = new PKCS8EncodedKeySpec(encodedPK);
    //         privateKey = factory.generatePrivate(keySpecPv);

    //     } catch (Exception e) {
    //         System.out.println(e);
    //     }

    //     return privateKey;
    // }

    /**
     * 
     * @param clientId
     * @param loginUrl
     * @param loginId
     * @param privateKey
     * @return 
     */
    public static StringBuffer getToken(String clientId, String loginUrl, String loginId, PrivateKey privateKey) {
        StringBuffer token = new StringBuffer();
        try {
            //////////////////////
            // JWT Token Header //
            //////////////////////
 	        String header = "{\"alg\":\"RS256\"}";
	        String claimTemplate = "'{'\"iss\": \"{0}\", \"sub\": \"{1}\", \"aud\": \"{2}\", \"exp\": \"{3}\"'}'";
 
            //Encode the JWT Header and add it to our string to sign
            token.append(Base64.encodeBase64URLSafeString(header.getBytes("UTF-8")));

            //////////////////////
            // Claim Payload    //
            //////////////////////

            //Separate with a period
            token.append(".");
 
            //Create the JWT Claims Object
            String[] claimArray = new String[4];
            claimArray[0] = clientId;
            claimArray[1] = loginId;
            claimArray[2] = loginUrl;
            claimArray[3] = Long.toString((System.currentTimeMillis()/1000) + 300);
            MessageFormat claims;
            claims = new MessageFormat(claimTemplate);
            String payload = claims.format(claimArray);
 
            //Add the encoded claims object
            token.append(Base64.encodeBase64URLSafeString(payload.getBytes("UTF-8")));
            
            //////////////////////
            // Private Key      //
            //////////////////////

            //Sign the JWT Header + "." + JWT Claims Object
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(token.toString().getBytes("UTF-8"));
            String signedPayload = Base64.encodeBase64URLSafeString(signature.sign());
 
            //Separate with a period
            token.append(".");

            //Add the encoded signature
            token.append(signedPayload);
 
            System.out.println(token.toString());

        } catch(Exception e){
            System.out.println(e);
        }
        return token;
    }

    public static JsonObject getAuth(String clientId, String loginUrl, String loginId, PrivateKey privateKey) 
        throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        JsonObject jsonObject = null;
        try {
            //////////////////
            // Make a Token //
            //////////////////
            StringBuffer token = getToken(clientId, loginUrl, loginId, privateKey);

            //////////////////////
            // Query Token Part //
            //////////////////////
            String grant_type = "urn:ietf:params:oauth:grant-type:jwt-bearer";
                  
            String url = loginUrl + "/services/oauth2/token";
            List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("grant_type", grant_type));
            nameValuePairs.add(new BasicNameValuePair("assertion", token.toString()));

            HttpClient client = HttpClientBuilder.create().build();
            HttpPost req = new HttpPost(url);
            req.setHeader("Content-type", "application/x-www-form-urlencoded");
            HttpResponse response = null;
            try {
                req.setEntity(new UrlEncodedFormEntity(nameValuePairs, "utf-8"));
                response = client.execute(req);
                System.out.println(response.getStatusLine());
            } catch(UnsupportedEncodingException ueException){
                ueException.printStackTrace();
            } catch(ClientProtocolException cpException){
                cpException.printStackTrace();
            } catch(IOException ioException){
                ioException.printStackTrace();
            }

            final int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                System.out.println("Error authenticating to Force.com: " + statusCode);
                System.out.println(response.toString());
                return null;
            }

            String getResult = null;
            try {
                getResult = EntityUtils.toString(response.getEntity());
            } catch (IOException ioException) {
                ioException.printStackTrace();
            }

            try {
                JsonElement jl = JsonParser.parseString(getResult);
                jsonObject = jl.getAsJsonObject();
            } catch (JsonParseException jsonException) {
                jsonException.printStackTrace();
            }

            req.releaseConnection();

            System.out.println("Successful login");

        } catch (Exception e) {
            System.out.println(e);
        }

        return jsonObject;
    }

}
