package com.example;


import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class App 
{
    public static void main(String[] args) {
        try {

            ConnectionInfo connectionInfo = getAuth();

            System.out.println("Access Token : " + connectionInfo.getAccessToken());
            System.out.println("Instance Url : " + connectionInfo.getInstanceUrl());

            // Data function block begin
            querySample(connectionInfo);
            //batchSample(connectionInfo);
            //querySingle(connectionInfo);
            //createRecord(connectionInfo);
            //updateRecord(connectionInfo);
            //deleteRecord(connectionInfo);
            //createRecords(connectionInfo);
            //updateRecords(connectionInfo);
            //deleteRecords(connectionInfo);
            // Data function block end
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static ConnectionInfo getAuth(){
        ConnectionInfo info = new ConnectionInfo();
        try {
            String consumerKey = "3MVG9YDQS5WtC11q60F............QYX68awYhUzKVMMB";
            String loginUrl    = "https://login.salesforce.com/";
            String loginUser   = "username@example.com";

            // Converted PrivateKey(PKCS#1) to PKCS#8 by
            // openssl pkcs8 -topk8 -inform PEM -outform PEM -in rsa_private.key -out pkcs8PrivateKey.pem -nocrypt
            String pkcs8PrivateKeyString = "" +
            "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDN4c80VU9yjbAu" +
            "JWq3RYPBsLnP2wcipVdGIzPYLqyXUq2GBlhyaLjN0NI5mO+AyXE8FSJtD/Y22ILQ" +
            "..." +
            "..." +
            "..." +
            "Qmh4OV5ZHXwx5R6ffAOAwAY=";
            PrivateKey privateKey = Auth.getPrivateKeyFromString(pkcs8PrivateKeyString);
            // PrivateKey privateKey = Auth.getPrivateKeyFromKeyFile("./company.key");
            // PrivateKey privateKey = Auth.getPrivateKeyFromJKS("./company.jks", "company", "password");

            JsonObject jsonObject = Auth.getAuth(consumerKey, loginUrl, loginUser, privateKey);

            info.setAccessToken(jsonObject.get("access_token").toString().replaceAll("\"", ""));
            info.setInstanceUrl(jsonObject.get("instance_url").toString().replaceAll("\"", ""));
    
            // Gson gson = new GsonBuilder().setPrettyPrinting().create();
            // String json = gson.toJson(jsonObject);
            // System.out.println(json);

        } catch (Exception e) {
            System.out.println(e);
        }

        return info;
    }

    public static void querySample(ConnectionInfo connectionInfo){
        try {
            String query = "SELECT Id, Name FROM Account LIMIT 10";
            JsonObject jsonObject = Database.query(connectionInfo, query);


            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(jsonObject);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void batchSample(ConnectionInfo connectionInfo){
        try {
            String serviceEndpoint = "/services/data/v58.0/queryAll?q=";
            String query = "SELECT Id, Name FROM Account";
            String queryUrl = serviceEndpoint + URLEncoder.encode(query, StandardCharsets.UTF_8.toString());

            Integer batchSize = 200;

            JsonObject jsonObject = Database.batchQuery(connectionInfo, queryUrl, batchSize);

            Integer totalSize = jsonObject.get("totalSize").getAsInt();
            Boolean done = jsonObject.get("done").getAsBoolean();
            JsonArray records = (JsonArray) jsonObject.get("records");

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(records);

            System.out.println("total size : " + totalSize);
            System.out.println(json);

            while (!done) {
                queryUrl = jsonObject.get("nextRecordsUrl").getAsString();

                jsonObject = Database.batchQuery(connectionInfo, queryUrl, batchSize);
                done = jsonObject.get("done").getAsBoolean();
                records = (JsonArray) jsonObject.get("records");

                json = gson.toJson(records);
                System.out.println(json);
            }
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void querySingle(ConnectionInfo connectionInfo){
        try {
            String objectName = "Account";
            String recordId = "0016F00001sBS1LQAW";
            JsonObject jsonObject = Database.querySingle(connectionInfo, objectName, recordId);


            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(jsonObject);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void createRecord(ConnectionInfo connectionInfo){
        try {
            String objectName = "Account";
            String recordBody = "" +
            "{" +
            "    \"Name\" : \"Dev Test Company\"," +
            "    \"NumberOfEmployees\" : 100" +            
            "}";
            
            JsonObject jsonObject = Database.createRecord(connectionInfo, objectName, recordBody);

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(jsonObject);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void updateRecord(ConnectionInfo connectionInfo){
        try {
            String objectName = "Account";
            String recordId = "001IS000002kYvQYAU";
            String recordBody = "" +
            "{" +
            "    \"Name\" : \"Dev Test Company Modified\"," +
            "    \"NumberOfEmployees\" : 200" +            
            "}";
            
            JsonObject jsonObject = Database.updateRecord(connectionInfo, objectName, recordId, recordBody);

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(jsonObject);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void deleteRecord(ConnectionInfo connectionInfo){
        try {
            String objectName = "Account";
            String recordId = "001IS000002kYvQYAU";

            JsonObject jsonObject = Database.deleteRecord(connectionInfo, objectName, recordId);

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(jsonObject);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void createRecords(ConnectionInfo connectionInfo){
        try {
            JsonObject objectType = new JsonObject();
            objectType.addProperty("type", "Account");

            JsonArray records = new JsonArray();

            JsonObject rec1 = new JsonObject();
            rec1.add("attributes", objectType);
            rec1.addProperty("Name", "Test Company 1");                
            records.add(rec1);

            JsonObject rec2 = new JsonObject();
            rec2.add("attributes", objectType);
            rec2.addProperty("Name", "Test Company 2");                
            records.add(rec2);

            JsonObject collection = new JsonObject();
            collection.addProperty("allOrNone", false);
            collection.add("records", records);

            JsonArray result = Database.createRecords(connectionInfo, collection.toString());

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(result);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void updateRecords(ConnectionInfo connectionInfo){
        try {
		    String jsonString = "{" +
		    "    \"allOrNone\" : false," +
		    "    \"records\" : [{" +
		    "        \"attributes\" : {\"type\" : \"Account\"}," +
		    "        \"Id\" : \"001IS000002kYyUYAU\"," +
		    "        \"Name\" : \"Test Company 1 Modified\"" +
		    "     }, {" +
		    "        \"attributes\" : {\"type\" : \"Account\"}," +
		    "        \"Id\" : \"001IS000002kYyVYAU\"," +
		    "        \"Name\" : \"Test Company 2 Modified\"" +
		    "     }]" +
		    "}";

            JsonArray result = Database.updateRecords(connectionInfo, jsonString);

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(result);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void deleteRecords(ConnectionInfo connectionInfo){
        try {
		    String ids = "001IS000002kYyUYAU,001IS000002kYyVYAU";
            String encodedIds = URLEncoder.encode(ids, StandardCharsets.UTF_8.toString());

            JsonArray result = Database.deleteRecords(connectionInfo, encodedIds);

            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(result);

            System.out.println(json);
        } catch (Exception e) {
            System.out.println(e);
        }
    }

}
